---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：1-Issue Reporter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：目標出力時間の根拠なし
  2. **同時出力数上限**：実装からの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/issue/common/issue.ts` - IssueType enum (行20-24)
- E-02: `src/vs/workbench/contrib/issue/common/issue.ts` - IssueReporterData interface (行67-82)
- E-03: `src/vs/workbench/contrib/issue/browser/issueReporterModel.ts` - IssueReporterData interface (行15-48)
- E-04: `src/vs/workbench/contrib/issue/browser/issueReporterModel.ts` - serialize() method (行85-104)
- E-05: `src/vs/workbench/contrib/issue/browser/issueReporterModel.ts` - generateSystemInfoMd() (行191-236)
- E-06: `src/vs/workbench/contrib/issue/browser/issueReporterModel.ts` - generateExtensionsMd() (行274-298)
- E-07: `src/vs/workbench/contrib/issue/browser/baseIssueReporterService.ts` - MAX_URL_LENGTH (行36)
- E-08: `src/vs/workbench/contrib/issue/browser/baseIssueReporterService.ts` - MAX_EXTENSION_DATA_LENGTH (行42)
- E-09: `src/vs/workbench/contrib/issue/browser/baseIssueReporterService.ts` - createIssue() (行1233-1314)
- E-10: `src/vs/workbench/contrib/issue/browser/baseIssueReporterService.ts` - submitToGitHub() (行1207-1231)
- E-11: `src/vs/workbench/contrib/issue/browser/baseIssueReporterService.ts` - validateInputs() (行1194-1205)
- E-12: `src/vs/workbench/contrib/issue/browser/baseIssueReporterService.ts` - validateInput() (行1165-1192)
- E-13: `src/vs/workbench/contrib/issue/browser/issueReporterModel.ts` - getInfos() (行141-185)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Issue TypeはBug/PerformanceIssue/FeatureRequestの3種類 | E-01 | ○ |
| C-02 | IssueReporterDataにissueType, issueDescription等が含まれる | E-02, E-03 | ○ |
| C-03 | serialize()メソッドがMarkdown形式のレポートを生成 | E-04 | ○ |
| C-04 | System InfoにCPU, GPU, Memory等の情報が含まれる | E-05 | ○ |
| C-05 | 拡張機能一覧がテーブル形式で出力される | E-06 | ○ |
| C-06 | 最大URL長は7,500文字 | E-07 | ○ |
| C-07 | 拡張機能データ上限は60,000文字 | E-08 | ○ |
| C-08 | createIssue()でIssue作成処理が実行される | E-09 | ○ |
| C-09 | GitHub認証時はAPI経由で直接Issue作成 | E-10 | ○ |
| C-10 | 入力検証でTitle, Description, Sourceが必須 | E-11 | ○ |
| C-11 | Descriptionは10文字以上必要 | E-12 (行1179) | ○ |
| C-12 | Bug/PerformanceIssueでSystem Infoが含まれる | E-13 (行148-162) | ○ |
| C-13 | PerformanceIssueでProcess/Workspace Infoが含まれる | E-13 (行164-172) | ○ |
| C-14 | Feature RequestではSystem Info等が含まれない | E-13 (行148) | ○ |
| C-15 | 拡張機能の作成者は3文字に切り詰められる | E-06 (行288) | ○ |
| C-16 | テーマ拡張機能は一覧から除外される | E-06 (行275-279) | ○ |
| C-17 | URL超過時はクリップボードにコピー | E-09 (行1301-1308) | ○ |
| C-18 | serialize()で`<!-- generated by issue reporter -->`が付与 | E-04 (行103) | ○ |
| C-19 | Restricted/Unsupportedモードが表示される | E-04 (行86-92) | ○ |
| C-20 | リモート接続時にRemote OS情報が追加される | E-04 (行101), E-05 (行216-230) | ○ |
| C-21 | GitHub APIへの送信はBearerトークンで認証 | E-10 (行1217) | ○ |
| C-22 | validateInput()でinvalid-inputクラスが追加される | E-12 (行1175) | ○ |
| C-23 | A/B Experiments情報が折りたたみブロックで出力 | E-04 (行262-271) | ○ |
| C-24 | Process Info/Workspace Infoはコードブロックで出力 | E-04 (行238-260) | ○ |
| C-25 | 拡張機能起因の場合は拡張機能バージョンが追加 | E-04 (行123-129) | ○ |
| C-26 | IssueSourceにVSCode/Extension/Marketplace/Unknownがある | E-07周辺 (行50-55) | ○ |
| C-27 | Linux環境ではデスクトップセッション情報が追加 | E-05 (行209-214) | ○ |
| C-28 | GPU Statusは複数のキー値ペアで表示 | E-05 (行202) | ○ |
| C-29 | 拡張機能が無効の場合は「Extensions disabled」と表示 | E-06 (行275-277) | ○ |
| C-30 | 拡張機能がない場合は「Extensions: none」と表示 | E-06 (行281-282) | ○ |
| C-31 | 目標出力時間は3秒以内 | **根拠なし** | △ |
| C-32 | 同時出力数上限は1件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（目標出力時間、同時出力数）は実装コードに明示的な定義がない
  - 候補：パフォーマンステスト仕様書 / 要件定義書 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造・出力形式の記述（E-01〜E-06に基づく）
- 0: 低リスク - URL制限・検証ロジック（E-07〜E-12に基づく）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）

## 6) レビュアーチェックリスト（最小）
- [ ] Issue Typeの3種類（Bug/PerformanceIssue/FeatureRequest）が正しいか
- [ ] 出力形式の記述がserialize()メソッドと一致しているか
- [ ] URL制限値（7,500文字、60,000文字）が最新の実装と一致しているか
- [ ] 入力検証条件（10文字以上等）が実装と一致しているか
- [ ] パフォーマンス要件の妥当性を確認（要件定義書との突合）
